# 🚀 Welcome to LightZero! 🌟

We're thrilled that you want to contribute to LightZero. Your help is invaluable, and we appreciate your efforts to make this project even better. 😄

## 📝 How to Contribute

1. **Fork the Repository** 🍴
   - Click on the "Fork" button at the top right of the [LightZero repository](https://github.com/opendilab/LightZero).

2. **Clone your Fork** 💻
   - `git clone https://github.com/your-username/LightZero.git`

3. **Create a New Branch** 🌿
   - `git checkout -b your-new-feature`

4. **Make Your Awesome Changes** 💥
   - Add some cool features.
   - Fix a bug.
   - Improve the documentation.
   - Anything that adds value!

5. **Commit Your Changes** 📦
   - `git commit -m "Your descriptive commit message"`

6. **Push to Your Fork** 🚢
   - `git push origin your-new-feature`

7. **Create a Pull Request** 🎉
   - Go to the [LightZero repository](https://github.com/opendilab/LightZero).
   - Click on "New Pull Request."
   - Fill in the details and submit your PR.
   - Please make sure your PR has a clear title and description.

8. **Review & Collaborate** 🤝
   - Be prepared to answer questions or make changes to your PR as requested by the maintainers.

9. **Celebrate! 🎉** Your contribution has been added to LightZero.

## 📦 Reporting Issues

If you encounter a bug or have an idea for an improvement, please create an issue in the [Issues](https://github.com/opendilab/LightZero/issues) section. Make sure to include details about the problem and how to reproduce it.

## 🛠 Code Style and Guidelines

We follow a few simple guidelines:
- Keep your code clean and readable.
- Use meaningful variable and function names.
- Comment your code when necessary.
- Ensure your code adheres to existing coding styles and standards.

For detailed information on code style, unit testing, and code review, please refer to our documentation:

- [Code Style](https://di-engine-docs.readthedocs.io/en/latest/21_code_style/index.html)
- [Unit Test](https://di-engine-docs.readthedocs.io/en/latest/22_test/index.html)
- [Code Review](https://di-engine-docs.readthedocs.io/en/latest/24_cooperation/git_guide.html)

## 🤖 Code of Conduct

Please be kind and respectful when interacting with other contributors. We have a [Code of Conduct](LICENSE) to ensure a positive and welcoming environment for everyone.

## 🙌 Thank You! 🙏

Your contribution helps make LightZero even better. We appreciate your dedication to the project. Keep coding and stay awesome! 😃
